/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.KoboldEntity;
import net.salju.kobolds.init.KoboldsModEntities;
import net.salju.kobolds.init.KoboldsModSounds;

public class KoboldRascalEntity
extends AbstractKoboldEntity {
    public boolean isFound;

    public KoboldRascalEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<KoboldRascalEntity>)((EntityType)KoboldsModEntities.KOBOLD_RASCAL.get()), world);
    }

    public KoboldRascalEntity(EntityType<KoboldRascalEntity> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
    }

    @Override
    public boolean m_6785_(double distanceToClosestPlayer) {
        return true;
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if (!this.isFound && !this.m_21023_(MobEffects.f_19609_)) {
            this.isFound = true;
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        super.m_6071_(player, hand);
        Level world = this.f_19853_;
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        if (!this.isFound) {
            if (!world.m_5776_()) {
                player.m_21011_(hand, true);
                this.m_21195_(MobEffects.f_19609_);
                if (Math.random() >= 0.92) {
                    this.m_21011_(InteractionHand.MAIN_HAND, true);
                    if (world instanceof ServerLevel) {
                        ServerLevel lvl = (ServerLevel)world;
                        this.m_5496_((SoundEvent)KoboldsModSounds.KOBOLD_TRADE.get(), 1.0f, 1.0f);
                        ItemEntity bundle = new ItemEntity((Level)lvl, x, y, z, new ItemStack((ItemLike)Items.f_151058_));
                        bundle.m_32010_(10);
                        lvl.m_7967_((Entity)bundle);
                    }
                }
            }
            this.isFound = true;
        }
        for (AbstractKoboldEntity kobolds : this.f_19853_.m_45976_(AbstractKoboldEntity.class, this.m_20191_().m_82400_(128.0))) {
            if (kobolds instanceof KoboldRascalEntity) continue;
            this.m_21573_().m_26519_(kobolds.m_20185_(), kobolds.m_20186_(), kobolds.m_20189_(), 1.2);
        }
        return InteractionResult.FAIL;
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)KoboldsModEntities.KOBOLD_RASCAL.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            return y < 56 && !world.m_5776_() && world.m_46859_(new BlockPos(x, y, z)) && world.m_8055_(new BlockPos(x, y, z)).getLightEmission((BlockGetter)world, new BlockPos(x, y, z)) <= 2 && !world.m_6443_(KoboldEntity.class, AABB.m_165882_((Vec3)new Vec3((double)x, (double)y, (double)z), (double)64.0, (double)64.0, (double)64.0), e -> true).isEmpty() && world.m_6443_(KoboldRascalEntity.class, AABB.m_165882_((Vec3)new Vec3((double)x, (double)y, (double)z), (double)128.0, (double)128.0, (double)128.0), e -> true).isEmpty();
        });
    }

    @Override
    protected boolean m_7808_(ItemStack drop, ItemStack hand) {
        if (drop.m_41720_() instanceof SwordItem) {
            if (hand.m_41619_() && this.m_21206_().m_41720_() instanceof TridentItem) {
                return false;
            }
            if (!(hand.m_41720_() instanceof SwordItem)) {
                return true;
            }
            SwordItem newbie = (SwordItem)drop.m_41720_();
            SwordItem weapon = (SwordItem)hand.m_41720_();
            if (newbie.m_43299_() != weapon.m_43299_()) {
                return newbie.m_43299_() > weapon.m_43299_();
            }
            return this.m_21477_(drop, hand);
        }
        if (drop.m_41720_() instanceof ArmorItem) {
            if (EnchantmentHelper.m_44920_((ItemStack)hand)) {
                return false;
            }
            if (hand.m_41619_() || hand.m_41720_() instanceof BlockItem) {
                return true;
            }
            if (hand.m_41720_() instanceof ArmorItem) {
                ArmorItem newbie = (ArmorItem)drop.m_41720_();
                ArmorItem worn = (ArmorItem)hand.m_41720_();
                if (newbie.m_40404_() != worn.m_40404_()) {
                    return newbie.m_40404_() > worn.m_40404_();
                }
                if (newbie.m_40405_() != worn.m_40405_()) {
                    return newbie.m_40405_() > worn.m_40405_();
                }
                return this.m_21477_(drop, hand);
            }
            return false;
        }
        return false;
    }
}

